# Social interaction by group

# Import packages
import pandas as pd
import numpy as np
import math
import pickle
import os, sys

# Define a function: an adjacency matrix to a vector of pairs
def adjpair_dir(A):
    N=A.shape[0]
    y=np.array([0])
    for k in range(1,N+1):
        a=np.concatenate((A[0:k-1,k-1],A[k:N+1,k-1]),axis=0)
        y=np.append(y,a,axis=0)
    return y[1:y.shape[0]+1] 

# Data set-up
with open('spatial_interaction_finaldata_schools4to150.pkl','rb') as f:
    Data=pickle.load(f)
with open('BWcell_schools4to150.pkl','rb') as f:
    BLK=pickle.load(f)
SDcell=Data[1]
ADcell=Data[9]
H=len(SDcell)

# Calculation
FP=np.zeros([H,6])
for h in range(1,H+1):
    Ap1=adjpair_dir(ADcell[h-1])
    Bp=adjpair_dir(BLK[h-1])
    BLK_BLK_FR=Ap1*(Bp==2)
    BLK_WH_FR=Ap1*(Bp==1)
    WH_WH_FR=Ap1*(Bp==0)
    S1=adjpair_dir(SDcell[h-1])
    BLK_BLK_N=S1*(Bp==2)
    BLK_WH_N=S1*(Bp==1)
    WH_WH_N=S1*(Bp==0)
    FP[h-1,0]=np.sum(BLK_BLK_N)
    FP[h-1,1]=np.sum(BLK_WH_N)
    FP[h-1,2]=np.sum(WH_WH_N)
    FP[h-1,3]=np.sum(BLK_BLK_FR)
    FP[h-1,4]=np.sum(BLK_WH_FR)
    FP[h-1,5]=np.sum(WH_WH_FR)

# Making a table
TB=np.zeros([3,4])
TB[0,0:3]=np.sum(FP[:,0:3],axis=0)
TB[1,0:3]=np.sum(FP[:,3:6],axis=0)
TB[0,3]=np.sum(TB[0,0:3])
TB[1,3]=np.sum(TB[1,0:3])
TB[2,0]=TB[0,0]/TB[1,0]
TB[2,1]=TB[0,1]/TB[1,1]
TB[2,2]=TB[0,2]/TB[1,2]
TB[2,3]=TB[0,3]/TB[1,3]

with open('TB_groups.pkl','wb') as f:
    pickle.dump(TB,f)
